<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Template;

class TemplateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $templates = [
            ['id' => 1, 'name' => 'Article Generator', 'icon' => '<i class="fa-solid fa-file-lines main-icon"></i>', 'description' => 'Turn a title and outline text into a fully complete high quality article within seconds', 'template_code' => 'KPAQQ', 'status' => true, 'professional' => false, 'group' => 'text', 'slug' => 'article-generator', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Article Title","placeholder":"e.g. Amazing cuisine culture of Mexico", "required":1, "input":"input","code":"title", "length":200}, {"name":"Focus Keywords","placeholder":"e.g. taco, sangria, paella", "required":0, "input":"textarea","code":"keywords", "length":600}]'],
            ['id' => 2, 'name' => 'Content Rewriter', 'icon' => '<i class="fa-solid fa-square-check main-icon"></i>', 'description' => 'Take a piece of content and rewrite it to make it more interesting, creative, and engaging', 'template_code' => 'WCZGL', 'status' => true, 'professional' => false, 'group' => 'text', 'slug' => 'content-rewriter', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"What would you like to rewrite?", "placeholder":"Enter your text to rewrite...", "required":1, "input":"textarea","code":"description", "length":8000}]'],
            ['id' => 3, 'name' => 'Paragraph Generator', 'icon' => '<i class="fa-solid fa-line-columns main-icon"></i>', 'description' => 'Generate paragraphs about any topic including a keyword and in a specific tone of voice', 'template_code' => 'JXRZB', 'status' => true, 'professional' => false, 'group' => 'text', 'slug' => 'paragraph-generator', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Paragraph Description", "placeholder":"Provide details of what you want to write about...", "required":1, "input":"textarea","code":"description", "length":600}, {"name":"Focus Keywords","placeholder":"e.g. fruit, lime", "required":0, "input":"input","code":"keywords", "length":400}]'],
            ['id' => 4, 'name' => 'Talking Points', 'icon' => '<i class="fa-solid fa-list-check main-icon"></i>', 'description' => 'Write short, simple and informative points for the subheadings of your article', 'template_code' => 'VFWSQ', 'status' => true, 'professional' => false, 'group' => 'text', 'slug' => 'talking-points', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Article Title","placeholder":"e.g. 10 ways to create websites", "required":1, "input":"input","code":"title", "length":400}, {"name":"Subheading Description","placeholder":"e.g. Why you should create a website", "required":1, "input":"textarea","code":"description", "length":600}]'],
            ['id' => 5, 'name' => 'Pros & Cons', 'icon' => '<i class="fa-solid fa-code-compare main-icon"></i>', 'description' => 'Write the pros and cons of a product, service or website for your blog article', 'template_code' => 'OPYAB', 'status' => true, 'professional' => false, 'group' => 'text', 'slug' => 'pros-and-cons', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Name","placeholder":"e.g. iPhone, Samsung", "required":1, "input":"input","code":"title", "length":200}, {"name":"Product Description","placeholder":"e.g. Explain what kind of cell phone you can to compare", "required":1, "input":"textarea","code":"description", "length":600}]'],
            ['id' => 6, 'name' => 'Blog Titles', 'icon' => '<i class="fa-solid fa-message-text blog-icon"></i>', 'description' => 'Nobody wants to read boring blog titles, generate catchy blog titles with this tool', 'template_code' => 'WGKYP', 'status' => true, 'professional' => false, 'group' => 'blog', 'slug' => 'blog-titles', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"What is your blog post is about?", "placeholder":"Describe your blog post...", "required":1, "input":"textarea","code":"description", "length":600}]'],
            ['id' => 7, 'name' => 'Blog Section', 'icon' => '<i class="fa-solid fa-message-lines blog-icon"></i>', 'description' => 'Write a full blog section (few paragraphs) about a subheading of your article', 'template_code' => 'EEKZF', 'status' => true, 'professional' => false, 'group' => 'blog', 'slug' => 'blog-section', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Title of your blog article","placeholder":"e.g. 5 best places to visit in Spain", "required":1, "input":"input","code":"title", "length":400}, {"name":"Subheadings","placeholder":"e.g. Barcelona, San Sebastian, Madrid", "required":1, "input":"textarea","code":"description", "length":600}]'],
            ['id' => 8, 'name' => 'Blog Ideas', 'icon' => '<i class="fa-solid fa-message-dots blog-icon"></i>', 'description' => 'The perfect tool to start writing great articles. Generate creative ideas for your next post', 'template_code' => 'KDGOX', 'status' => true, 'professional' => false, 'group' => 'blog', 'slug' => 'blog-ideas', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"What is your blog post is about?", "placeholder":"e.g. 5 best places to visit in Spain", "required":1, "input":"textarea","code":"title", "length":600}]'],
            ['id' => 9, 'name' => 'Blog Intros', 'icon' => '<i class="fa-solid fa-message-exclamation blog-icon"></i>', 'description' => 'Write an intro that will entice your visitors to read more about your article', 'template_code' => 'TZTYR', 'status' => true, 'professional' => false, 'group' => 'blog', 'slug' => 'blog-intros', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Blog Post Title","placeholder":"e.g. 5 best places to visit in Spain", "required":1, "input":"input","code":"title", "length":200}, {"name":"What is your blog post is about?","placeholder":"Describe your blog article", "required":1, "input":"textarea","code":"description", "length":600}]'],
            ['id' => 10, 'name' => 'Blog Conclusion', 'icon' => '<i class="fa-solid fa-message-check blog-icon"></i>', 'description' => 'End your blog articles with an engaging conclusion paragraph', 'template_code' => 'ZGUKM', 'status' => true, 'professional' => false, 'group' => 'blog', 'slug' => 'blog-conclusion', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Blog Post Title","placeholder":"e.g. 5 best places to visit in Spain", "required":1, "input":"input","code":"title", "length":200}, {"name":"What is your blog post is about?","placeholder":"Describe your blog article", "required":1, "input":"textarea","code":"description", "length":600}]'],
            ['id' => 11, 'name' => 'Summarize Text', 'icon' => '<i class="fa-solid fa-file-contract main-icon"></i>', 'description' => 'Summarize any text in a short and easy to understand concise way', 'template_code' => 'OMMEI', 'status' => true, 'professional' => false, 'group' => 'text', 'slug' => 'summarize-text', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"What would you like to summarize?", "placeholder":"Enter your text to summarize...", "required":1, "input":"textarea","code":"description", "length":8000}]'],
            ['id' => 12, 'name' => 'Product Description', 'icon' => '<i class="fa-solid fa-list-check main-icon"></i>', 'description' => 'Write the description about your product and why it worth it', 'template_code' => 'HXLNA', 'status' => true, 'professional' => false, 'group' => 'text', 'slug' => 'product-description', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Name","placeholder":"e.g. VR, Oculus", "required":1, "input":"input","code":"title", "length":200}, {"name":"Audience","placeholder":"e.g. Women, Aliens", "required":0, "input":"input","code":"audience", "length":200}, {"name":"Product Description","placeholder":"e.g. VR is an innovative device that can allow you to be part of virtual world", "required":1, "input":"textarea","code":"description", "length":600}]'],
            ['id' => 13, 'name' => 'Startup Name Generator', 'icon' => '<i class="fa-solid fa-lightbulb-on main-icon"></i>', 'description' => 'Generate cool, creative, and catchy names for your startup in seconds', 'template_code' => 'DJSVM', 'status' => true, 'professional' => false, 'group' => 'text', 'slug' => 'startup-name-generator', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Startup Description", "placeholder":"Explain what your statrup idea is about...", "required":1, "input":"textarea","code":"description", "length":600}, {"name":"Seed words","placeholder":"e.g. flow, app, tech", "required":0, "input":"input","code":"keywords", "length":200}]'],
            ['id' => 14, 'name' => 'Product Name Generator', 'icon' => '<i class="fa-solid fa-box-circle-check main-icon"></i>', 'description' => 'Create creative product names from examples words', 'template_code' => 'IXKBE', 'status' => true, 'professional' => false, 'group' => 'text', 'slug' => 'product-name-generator', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Description", "placeholder":"Provide product details...", "required":1, "input":"textarea","code":"description", "length":600}, {"name":"Seed words","placeholder":"e.g. fast, healthy, compact", "required":0, "input":"input","code":"keywords", "length":200}]'],
            ['id' => 15, 'name' => 'Meta Description', 'icon' => '<i class="fa-solid fa-memo-circle-info web-icon"></i>', 'description' => 'Write SEO-optimized meta description based on a description', 'template_code' => 'JCDIK', 'status' => true, 'professional' => false, 'group' => 'web', 'slug' => 'meta-description', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Website Name", "placeholder":"e.g. Amazon, Google", "required":1, "input":"input","code":"title", "length":200}, {"name":"Website Description", "placeholder":"Describe what your website or business...", "required":1, "input":"textarea","code":"description", "length":600}, {"name":"Keywords", "placeholder":"e.g. cloud services, databases", "required":0, "input":"input","code":"keywords", "length":400}]'],
            ['id' => 16, 'name' => 'FAQs', 'icon' => '<i class="fa-solid fa-message-question web-icon"></i>', 'description' => 'Generate frequently asked questions based on your product description', 'template_code' => 'SZAUF', 'status' => true, 'professional' => false, 'group' => 'web', 'slug' => 'faqs', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Name", "placeholder":"e.g. baby toys", "required":1, "input":"input","code":"title", "length":200}, {"name":"Product Description", "placeholder":"Describe what your product or service does...", "required":1, "input":"textarea","code":"description", "length":600}]'],
            ['id' => 17, 'name' => 'FAQ Answers', 'icon' => '<i class="fa-solid fa-messages-question web-icon"></i>', 'description' => 'Generate creative answers to questions (FAQs) about your business or website', 'template_code' => 'BFENK', 'status' => true, 'professional' => false, 'group' => 'web', 'slug' => 'faq-answers', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Name", "placeholder":"e.g. baby toys", "required":1, "input":"input","code":"title", "length":200}, {"name":"What is the question you are generating answers for?", "placeholder":"e.g. How to use this product?", "required":1, "input":"textarea","code":"question", "length":600}, {"name":"Product Description", "placeholder":"Describe what your product or service does...", "required":1, "input":"textarea","code":"description", "length":600}]'],
            ['id' => 18, 'name' => 'Testimonials / Reviews', 'icon' => '<i class="fa-solid fa-star-sharp-half-stroke web-icon"></i>', 'description' => 'Add social proof to your website by generating user testimonials', 'template_code' => 'XLGPP', 'status' => true, 'professional' => false, 'group' => 'web', 'slug' => 'testimonials', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Name", "placeholder":"e.g. baby toys", "required":1, "input":"input","code":"title", "length":200}, {"name":"Product Description", "placeholder":"Describe what your product or service does...", "required":1, "input":"textarea","code":"description", "length":600}]'],
            ['id' => 19, 'name' => 'Facebook Ads', 'icon' => '<i class="fa-brands fa-facebook social-icon"></i>', 'description' => 'Write Facebook ads that engage your audience and deliver a high conversion rate', 'template_code' => 'CTMNI', 'status' => true, 'professional' => false, 'group' => 'social', 'slug' => 'facebook-ads', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Name","placeholder":"e.g. VR, Oculus", "required":1, "input":"input","code":"title", "length":200}, {"name":"Audience","placeholder":"e.g. Women, Aliens", "required":0, "input":"input","code":"audience", "length":200}, {"name":"Product Description","placeholder":"e.g. VR is an innovative device that can allow you to be part of virtual world", "required":1, "input":"textarea","code":"description", "length":600}]'],
            ['id' => 20, 'name' => 'Video Descriptions', 'icon' => '<i class="fa-brands fa-youtube video-icon"></i>', 'description' => 'Write compelling YouTube descriptions to get people interested in your video', 'template_code' => 'ZLKSP', 'status' => true, 'professional' => false, 'group' => 'video', 'slug' => 'video-descriptions', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"What is the title of your video?", "placeholder":"e.g. start earning money online", "required":1, "input":"input","code":"title", "length":400}]'],
            ['id' => 21, 'name' => 'Video Titles', 'icon' => '<i class="fa-brands fa-youtube video-icon"></i>', 'description' => 'Write a compelling YouTube video title to catch everyones attention', 'template_code' => 'OJIOV', 'status' => true, 'professional' => false, 'group' => 'video', 'slug' => 'video-titles', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"What is your video about?", "placeholder":"Provide description of your video, provide as many details as possible...", "required":1, "input":"textarea","code":"description", "length":2000}]'],
            ['id' => 22, 'name' => 'Youtube Tags Generator', 'icon' => '<i class="fa-brands fa-youtube video-icon"></i>', 'description' => 'Generate SEO-optimized YouTube tags / keywords for your video', 'template_code' => 'ECNVU', 'status' => true, 'professional' => false, 'group' => 'video', 'slug' => 'youtube-tags-generator', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Enter your video title with keywords", "placeholder":"e.g. start earning money online", "required":1, "input":"textarea","code":"description", "length":2000}]'],
            ['id' => 23, 'name' => 'Instagram Captions', 'icon' => '<i class="fa-brands fa-instagram social-icon"></i>', 'description' => 'Grab attention with catchy captions for your Instagram posts', 'template_code' => 'EOASR', 'status' => true, 'professional' => false, 'group' => 'social', 'slug' => 'instagram-captions', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"What is your instagram post about?", "placeholder":"e.g. start earning money online", "required":1, "input":"textarea","code":"description", "length":2000}]'],
            ['id' => 24, 'name' => 'Instagram Hashtags Generator', 'icon' => '<i class="fa-brands fa-instagram social-icon"></i>', 'description' => 'Find the best hashtags to use for your Instagram posts', 'template_code' => 'IEMBM', 'status' => true, 'professional' => false, 'group' => 'social', 'slug' => 'instagram-hashtags', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Enter a Keyword", "placeholder":"e.g. makeup", "required":1, "input":"input","code":"title", "length":200}]'],
            ['id' => 25, 'name' => 'Social Media Post (Personal)', 'icon' => '<i class="fa-solid fa-thumbs-up social-icon"></i>', 'description' => 'Write a social media post for yourself to be published on any platform', 'template_code' => 'CKOHL', 'status' => true, 'professional' => false, 'group' => 'social', 'slug' => 'social-post-personal', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"What is this post about?", "placeholder":"e.g. I got fluent in Spanish in 1 week", "required":1, "input":"textarea","code":"description", "length":2000}]'],
            ['id' => 26, 'name' => 'Social Media Post (Business)', 'icon' => '<i class="fa-solid fa-thumbs-up social-icon"></i>', 'description' => 'Write a post for your business to be published on any social media platform', 'template_code' => 'ABWGU', 'status' => true, 'professional' => false, 'group' => 'social', 'slug' => 'social-post-business', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Company Name", "placeholder":"e.g. Amazon, Google", "required":1, "input":"input","code":"title", "length":200}, {"name":"Company Description", "placeholder":"e.g. Amazon is a leading vendor", "required":1, "input":"textarea","code":"description", "length":600}, {"name":"What is this post about?", "placeholder":"e.g. I got fluent in Spanish in 1 week", "required":1, "input":"textarea","code":"post", "length":2000}]'],
            ['id' => 27, 'name' => 'Facebook Headlines', 'icon' => '<i class="fa-brands fa-facebook social-icon"></i>', 'description' => 'Write catchy and convincing headlines to make your Facebook Ads stand out', 'template_code' => 'HJYJZ', 'status' => true, 'professional' => false, 'group' => 'social', 'slug' => 'facebook-headlines', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Name","placeholder":"e.g. VR, Oculus", "required":1, "input":"input","code":"title", "length":200}, {"name":"Audience","placeholder":"e.g. Women, Aliens", "required":0, "input":"input","code":"audience", "length":200}, {"name":"Product Description","placeholder":"e.g. VR is an innovative device that can allow you to be part of virtual world", "required":1, "input":"textarea","code":"description", "length":600}]'],
            ['id' => 28, 'name' => 'Google Ads Headlines', 'icon' => '<i class="fa-brands fa-google social-icon"></i>', 'description' => 'Write catchy 30-character headlines to promote your product with Google Ads', 'template_code' => 'SGZTW', 'status' => true, 'professional' => false, 'group' => 'social', 'slug' => 'google-headlines', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Name","placeholder":"e.g. VR, Oculus", "required":1, "input":"input","code":"title", "length":200}, {"name":"Audience","placeholder":"e.g. Women, Aliens", "required":0, "input":"input","code":"audience", "length":200}, {"name":"Product Description","placeholder":"e.g. VR is an innovative device that can allow you to be part of virtual world", "required":1, "input":"textarea","code":"description", "length":600}]'],
            ['id' => 29, 'name' => 'Google Ads Description', 'icon' => '<i class="fa-brands fa-google social-icon"></i>', 'description' => 'Write a Google Ads description that makes your ad stand out and generates leads', 'template_code' => 'YQAFG', 'status' => true, 'professional' => false, 'group' => 'social', 'slug' => 'google-ads', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Name","placeholder":"e.g. VR, Oculus", "required":1, "input":"input","code":"title", "length":200}, {"name":"Audience","placeholder":"e.g. Women, Aliens", "required":0, "input":"input","code":"audience", "length":200}, {"name":"Product Description","placeholder":"e.g. VR is an innovative device that can allow you to be part of virtual world", "required":1, "input":"textarea","code":"description", "length":600}]'],
            ['id' => 30, 'name' => 'Problem-Agitate-Solution (PAS) Framework', 'icon' => '<i class="fa-solid fa-pen-nib framework-icon"></i>', 'description' => 'Generate one of most effective copywriting formula for your business', 'template_code' => 'BGXJE', 'status' => true, 'professional' => false, 'group' => 'framework', 'slug' => 'problem-agitate-solution', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Name","placeholder":"e.g. VR, Oculus", "required":1, "input":"input","code":"title", "length":200}, {"name":"Audience","placeholder":"e.g. Women, Aliens", "required":0, "input":"input","code":"audience", "length":200}, {"name":"Product Description","placeholder":"e.g. VR is an innovative device that can allow you to be part of virtual world", "required":1, "input":"textarea","code":"description", "length":600}]'],
            ['id' => 31, 'name' => 'Academic Essay', 'icon' => '<i class="fa-solid fa-scroll-old main-icon"></i>', 'description' => 'Create creative academic essays for various subjects just in a second', 'template_code' => 'SXQBT', 'status' => true, 'professional' => false, 'group' => 'text', 'slug' => 'academic-essay', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Essay Title","placeholder":"e.g. Amazing cuisine culture of Mexico", "required":1, "input":"input","code":"title", "length":200}, {"name":"Focus Keywords","placeholder":"e.g. taco, sangria, paella", "required":0, "input":"textarea","code":"keywords", "length":2000}]'],
            ['id' => 32, 'name' => 'Welcome Email', 'icon' => '<i class="fa-solid fa-envelope-open-text email-icon"></i>', 'description' => 'Create welcome emails for your customers', 'template_code' => 'RLXGB', 'status' => true, 'professional' => false, 'group' => 'email', 'slug' => 'email-welcome', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Your Company/Product Name","placeholder":"e.g. Creative Minds", "required":1, "input":"input","code":"title", "length":200}, {"name":"Audience","placeholder":"e.g. Women, Aliens", "required":0, "input":"input","code":"audience", "length":200}, {"name":"Describe your Product or Company","placeholder":"", "required":1, "input":"textarea","code":"description", "length":2000}]'],
            ['id' => 33, 'name' => 'Cold Email', 'icon' => '<i class="fa-solid fa-mailbox email-icon"></i>', 'description' => 'Create professional cold emails with the help of AI', 'template_code' => 'RDJEZ', 'status' => true, 'professional' => false, 'group' => 'email', 'slug' => 'email-cold', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Your Company/Product Name","placeholder":"e.g. Creative Minds", "required":1, "input":"input","code":"title", "length":200}, {"name":"Context to include in the email","placeholder":"", "required":0, "input":"input","code":"keywords", "length":600}, {"name":"Describe your Product or Company","placeholder":"", "required":1, "input":"textarea","code":"description", "length":2000}]'],
            ['id' => 34, 'name' => 'Follow-Up Email', 'icon' => '<i class="fa-solid fa-reply-all email-icon"></i>', 'description' => 'Create professional email follow up with just few clicks', 'template_code' => 'XVNNQ', 'status' => true, 'professional' => false, 'group' => 'email', 'slug' => 'email-follow-up', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Your Company/Product Name","placeholder":"e.g. Creative Minds", "required":1, "input":"input","code":"title", "length":200}, {"name":"Following up after","placeholder":"", "required":0, "input":"input","code":"keywords", "length":600}, {"name":"Describe your Product or Company","placeholder":"", "required":1, "input":"textarea","code":"description", "length":2000}]'],
            ['id' => 35, 'name' => 'Creative Stories', 'icon' => '<i class="fa-solid fa-books main-icon"></i>', 'description' => 'Allow AI to generate creative stories for you based on input text', 'template_code' => 'PAKMF', 'status' => true, 'professional' => false, 'group' => 'text', 'slug' => 'creative-stories', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"What is your story is about?", "placeholder":"Provide as many details as possible for creating a story tale", "required":1, "input":"textarea","code":"description", "length":2000}]'],
            ['id' => 36, 'name' => 'Grammar Checker', 'icon' => '<i class="fa-solid fa-spell-check main-icon"></i>', 'description' => 'Make sure that there are no errors in your content', 'template_code' => 'OORHD', 'status' => true, 'professional' => false, 'group' => 'text', 'slug' => 'grammar-checker', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Include your text here to check", "placeholder":"", "required":1, "input":"textarea","code":"description", "length":8000}]'],
            ['id' => 37, 'name' => 'Summarize for 2nd Grader', 'icon' => '<i class="fa-solid fa-thought-bubble main-icon"></i>', 'description' => 'Summarize any complex content for a 2nd grader child', 'template_code' => 'SGJLU', 'status' => true, 'professional' => false, 'group' => 'text', 'slug' => '2nd-grader', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Include your text to summarize", "placeholder":"", "required":1, "input":"textarea","code":"description", "length":8000}]'],
            ['id' => 38, 'name' => 'Video Scripts', 'icon' => '<i class="fa-solid fa-film video-icon"></i>', 'description' => 'Quickly create scripts for your videos and start shooting', 'template_code' => 'WISHV', 'status' => true, 'professional' => false, 'group' => 'video', 'slug' => 'video-scripts', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"What is your video about?", "placeholder":"Provide description of what your video is about, provide all details", "required":1, "input":"textarea","code":"description", "length":6000}]'],
            ['id' => 39, 'name' => 'Amazon Product Description', 'icon' => '<i class="fa-brands fa-amazon ecommerce-icon"></i>', 'description' => 'Create attention grabbing amazon product description', 'template_code' => 'WISTT', 'status' => true, 'professional' => false, 'group' => 'ecommerce', 'slug' => 'amazon-product', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Name","placeholder":"e.g. baby toys", "required":1, "input":"input","code":"title", "length":200}, {"name":"Focus Keywords","placeholder":"e.g. soft, cotton, girl", "required":0, "input":"textarea","code":"keywords", "length":600}]'],          
            ['id' => 40, 'name' => 'Text Extender', 'icon' => '<i class="fa-solid fa-text-width main-icon"></i>', 'description' => 'Extend your sentences with more description and additional information', 'template_code' => 'LMMPR', 'status' => true, 'professional' => false, 'group' => 'text', 'slug' => 'text-extender', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Enter your text","placeholder":"Enter your text here...", "required":1, "input":"textarea","code":"description", "length":2000}, {"name":"Focus Keywords","placeholder":"e.g. soft, cotton, girl", "required":0, "input":"textarea","code":"keywords", "length":600}]'],
            ['id' => 41, 'name' => 'Rewrite with Keywords', 'icon' => '<i class="fa-solid fa-arrows-rotate main-icon"></i>', 'description' => 'Rewrite your existing content with including specific keywords', 'template_code' => 'NJLCK', 'status' => true, 'professional' => false, 'group' => 'text', 'slug' => 'rewrite-with-keywords', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Enter your text","placeholder":"Enter your text here...", "required":1, "input":"textarea","code":"description", "length":8000}, {"name":"Included Keywords","placeholder":"e.g. soft, cotton, girl", "required":0, "input":"textarea","code":"keywords", "length":600}]'],
            ['id' => 42, 'name' => 'Song Lyrics', 'icon' => '<i class="fa-solid fa-message-music other-icon"></i>', 'description' => 'Generate a song lyrics based on your description and keywords', 'template_code' => 'QJGQU', 'status' => true, 'professional' => false, 'group' => 'other', 'slug' => 'song-lyric', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Song description","placeholder":"Provide your song description here...", "required":1, "input":"textarea","code":"description", "length":2000}, {"name":"Focus Keywords","placeholder":"e.g. soft, cotton, girl", "required":0, "input":"textarea","code":"keywords", "length":400}]'],
            ['id' => 43, 'name' => 'Business Ideas', 'icon' => '<i class="fa-solid fa-user-tie-hair main-icon"></i>', 'description' => 'Generate business ideas based on your keywords and description', 'template_code' => 'IQWZV', 'status' => true, 'professional' => false, 'group' => 'text', 'slug' => 'business-ideas', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Industry description","placeholder":"Describe your target industry...", "required":1, "input":"textarea","code":"description", "length":2000}]'],
            ['id' => 44, 'name' => 'LinkedIn Posts', 'icon' => '<i class="fa-brands fa-linkedin-in social-icon"></i>', 'description' => 'Create an interesting linkedin post with the help of AI', 'template_code' => 'NEVUR', 'status' => true, 'professional' => false, 'group' => 'social', 'slug' => 'linkedin-post', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Describe your post","placeholder":"Enter your post details here...", "required":1, "input":"textarea","code":"description", "length":600}, {"name":"Focus Keywords","placeholder":"e.g. soft, cotton, girl", "required":0, "input":"textarea","code":"keywords", "length":400}]'],
            ['id' => 46, 'name' => 'Company Bio', 'icon' => '<i class="fa-solid fa-address-card web-icon"></i>', 'description' => 'Write a comprehensive company bio based on your inputs', 'template_code' => 'MQSHO', 'status' => true, 'professional' => false, 'group' => 'web', 'slug' => 'company-bio', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Company Name","placeholder":"Enter your company name...", "required":1, "input":"input","code":"title", "length":400}, {"name":"Company Description","placeholder":"Provide company information...", "required":1, "input":"textarea","code":"description", "length":2000}]'],
            ['id' => 47, 'name' => 'Email Subject Lines', 'icon' => '<i class="fa-solid fa-mailbox email-icon"></i>', 'description' => 'Create professional email suject lines', 'template_code' => 'TFYLZ', 'status' => true, 'professional' => false, 'group' => 'email', 'slug' => 'email-subjects', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Describe your email","placeholder":"Explain what is your email is about...", "required":1, "input":"textarea","code":"description", "length":2000}]'],
            ['id' => 48, 'name' => 'Product Benefits', 'icon' => '<i class="fa-brands fa-product-hunt ecommerce-icon"></i>', 'description' => 'List out product benefits via help of AI solution', 'template_code' => 'CPTXT', 'status' => true, 'professional' => false, 'group' => 'ecommerce', 'slug' => 'product-benefits', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Name","placeholder":"Enter your product name here...", "required":1, "input":"input","code":"title", "length":400}, {"name":"Product Description","placeholder":"Describe your product...", "required":0, "input":"textarea","code":"description", "length":2000}]'],
            ['id' => 49, 'name' => 'Selling Product Titles', 'icon' => '<i class="fa-solid fa-heading ecommerce-icon"></i>', 'description' => 'Find out selling product titles for your product description', 'template_code' => 'KMKBQ', 'status' => true, 'professional' => false, 'group' => 'ecommerce', 'slug' => 'selling-titles', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Name","placeholder":"Enter your product name here...", "required":1, "input":"input","code":"title", "length":400}, {"name":"Product Description","placeholder":"Describe your product...", "required":0, "input":"textarea","code":"description", "length":2000}]'],
            ['id' => 50, 'name' => 'Product Comparisons', 'icon' => '<i class="fa-brands fa-product-hunt ecommerce-icon"></i>', 'description' => 'Create a comprehensize comparison of two products between each other', 'template_code' => 'UNOEP', 'status' => true, 'professional' => false, 'group' => 'ecommerce', 'slug' => 'product-comparison', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Products to Compare","placeholder":"iPhone vs Samsung", "required":1, "input":"input","code":"title", "length":400}]'],
            ['id' => 51, 'name' => 'Product Characteristics', 'icon' => '<i class="fa-brands fa-product-hunt ecommerce-icon"></i>', 'description' => 'Write a full prodcut characteristics', 'template_code' => 'RKYNX', 'status' => true, 'professional' => false, 'group' => 'ecommerce', 'slug' => 'product-characteristics', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Name","placeholder":"Enter your product name here...", "required":1, "input":"input","code":"title", "length":400}, {"name":"Focus Keywords","placeholder":"e.g. soft, cotton, girl", "required":0, "input":"textarea","code":"keywords", "length":400}]'],
            ['id' => 52, 'name' => 'Twitter Tweets', 'icon' => '<i class="fa-brands fa-twitter social-icon"></i>', 'description' => 'Generate an intersting twitter tweets with AI', 'template_code' => 'YVEFP', 'status' => true, 'professional' => false, 'group' => 'social', 'slug' => 'twitter-tweets', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Tweet Description","placeholder":"What do you want to tweet about...", "required":1, "input":"textarea","code":"description", "length":600}]'],
            ['id' => 53, 'name' => 'TitTok Video Scripts', 'icon' => '<i class="fa-solid fa-video-plus video-icon"></i>', 'description' => 'Video scripts that are ready to shoot and will make you go viral', 'template_code' => 'PEVVE', 'status' => true, 'professional' => false, 'group' => 'video', 'slug' => 'tiktok-script', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Video Description","placeholder":"Describe your tiktok video...", "required":1, "input":"textarea","code":"description", "length":2000}]'],
            ['id' => 54, 'name' => 'LinkedIn Ad Headlines', 'icon' => '<i class="fa-brands fa-linkedin-in social-icon"></i>', 'description' => 'Attention-grabbing, click-inducing and high-converting ad headlines for LinkedIn', 'template_code' => 'WMRJR', 'status' => true, 'professional' => false, 'group' => 'social', 'slug' => 'linkedin-headlines', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Name","placeholder":"e.g. VR, Oculus", "required":1, "input":"input","code":"title", "length":200}, {"name":"Audience","placeholder":"e.g. Women, Aliens", "required":0, "input":"input","code":"audience", "length":200}, {"name":"Product Description","placeholder":"e.g. VR is an innovative device that can allow you to be part of virtual world", "required":1, "input":"textarea","code":"description", "length":600}]'],
            ['id' => 55, 'name' => 'LinkedIn Ad Descriptions', 'icon' => '<i class="fa-brands fa-linkedin-in social-icon"></i>', 'description' => 'Professional and eye-catching ad descriptions that will make your product shine', 'template_code' => 'SSWNL', 'status' => true, 'professional' => false, 'group' => 'social', 'slug' => 'linkedin-description', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Name","placeholder":"e.g. VR, Oculus", "required":1, "input":"input","code":"title", "length":200}, {"name":"Audience","placeholder":"e.g. Women, Aliens", "required":0, "input":"input","code":"audience", "length":200}, {"name":"Product Description","placeholder":"e.g. VR is an innovative device that can allow you to be part of virtual world", "required":1, "input":"textarea","code":"description", "length":600}]'],
            ['id' => 56, 'name' => 'App and SMS Notifications', 'icon' => '<i class="fa-solid fa-message-sms other-icon"></i>', 'description' => 'Notification messages for your apps, websites and mobile devices that grabs users attention', 'template_code' => 'HRXVL', 'status' => true, 'professional' => false, 'group' => 'other', 'slug' => 'sms-notification', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Notification Description","placeholder":"Enter your notification details...", "required":1, "input":"textarea","code":"description", "length":600}]'],
            ['id' => 57, 'name' => 'Tone Changer', 'icon' => '<i class="fa-solid fa-arrows-turn-to-dots main-icon"></i>', 'description' => 'Change the tone of your writing to match your audience', 'template_code' => 'SYVKG', 'status' => true, 'professional' => false, 'group' => 'text', 'slug' => 'tone-changer', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Target Text","placeholder":"Enter your text here...", "required":1, "input":"textarea","code":"description", "length":8000}]'], 
            ['id' => 58, 'name' => 'Amazon Product Features', 'icon' => '<i class="fa-brands fa-amazon ecommerce-icon"></i>', 'description' => 'Advantages and features of your products that will make them irresistable for shoppers', 'template_code' => 'ETEDT', 'status' => true, 'professional' => false, 'group' => 'ecommerce', 'slug' => 'amazon-product-feature', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Name","placeholder":"e.g. VR, Oculus", "required":1, "input":"input","code":"title", "length":200}, {"name":"Audience","placeholder":"e.g. Women, Aliens", "required":0, "input":"input","code":"audience", "length":200}, {"name":"Product Description","placeholder":"e.g. VR is an innovative device that can allow you to be part of virtual world", "required":1, "input":"textarea","code":"description", "length":600}]'],
            ['id' => 59, 'name' => 'Dictionary', 'icon' => '<i class="fa-solid fa-spell-check main-icon"></i>', 'description' => 'Use a dictionary to find all details of your word', 'template_code' => 'SNINY', 'status' => true, 'professional' => false, 'group' => 'text', 'slug' => 'dictionary', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Word","placeholder":"Enter your word here...", "required":1, "input":"input","code":"title", "length":200}]'],
            ['id' => 60, 'name' => 'Privacy Policy', 'icon' => '<i class="fa-solid fa-shield-halved main-icon"></i>', 'description' => 'Develop a privacy policy information for your organization', 'template_code' => 'GUXCM', 'status' => true, 'professional' => false, 'group' => 'text', 'slug' => 'privacy-policy', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Platform Name","placeholder":"e.g Website/Business Name", "required":1, "input":"input","code":"title", "length":200}, {"name":"Full Platform Description","placeholder":"Enter your plaform description here...", "required":1, "input":"textarea","code":"description", "length":2000}]'],
            ['id' => 61, 'name' => 'Terms and Conditions', 'icon' => '<i class="fa-solid fa-shield-quartered main-icon"></i>', 'description' => 'Develop a terms and conditions information for your organization', 'template_code' => 'LWOKG', 'status' => true, 'professional' => false, 'group' => 'text', 'slug' => 'terms-conditions', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Platform Name","placeholder":"e.g Website/Business Name", "required":1, "input":"input","code":"title", "length":200}, {"name":"Full Platform Description","placeholder":"Enter your plaform description here...", "required":1, "input":"textarea","code":"description", "length":2000}]'],
            ['id' => 62, 'name' => 'Clickbait Titles', 'icon' => '<i class="fa-solid fa-fishing-rod ad-icon"></i>', 'description' => 'Create a creative clickbait titles for your products', 'template_code' => 'CHJGF', 'status' => true, 'professional' => false, 'group' => 'ad', 'slug' => 'clickbait-title', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Description","placeholder":"Enter your product description here...", "required":1, "input":"textarea","code":"description", "length":2000}]'],
            ['id' => 63, 'name' => 'Company Press Release', 'icon' => '<i class="fa-solid fa-rectangles-mixed marketing-icon"></i>', 'description' => 'Write a company press release with the help of AI', 'template_code' => 'JKTUY', 'status' => true, 'professional' => false, 'group' => 'marketing', 'slug' => 'company-press-release', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Company Name","placeholder":"Enter your company name...", "required":1, "input":"input","code":"title", "length":200}, {"name":"Company Description","placeholder":"Provide company information..", "required":1, "input":"textarea","code":"description", "length":2000}, {"name":"What is the press release is about?","placeholder":"Describe press release information...", "required":1, "input":"textarea","code":"audience", "length":2000}]'],
            ['id' => 64, 'name' => 'Brand/Product Press Release', 'icon' => '<i class="fa-solid fa-rectangles-mixed marketing-icon"></i>', 'description' => 'Write a brand or prodcut press release with the help of AI', 'template_code' => 'XTABO', 'status' => true, 'professional' => false, 'group' => 'marketing', 'slug' => 'product-press-release', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Name","placeholder":"Enter your product name here...", "required":1, "input":"input","code":"title", "length":200}, {"name":"Product Description","placeholder":"Describe your product..", "required":1, "input":"textarea","code":"description", "length":2000}, {"name":"What is the press release is about?","placeholder":"Describe press release information...", "required":1, "input":"textarea","code":"audience", "length":2000}]'],
            ['id' => 65, 'name' => 'Attention-Interest-Desire-Action (AIDA) Framework', 'icon' => '<i class="fa-solid fa-pen-nib framework-icon"></i>', 'description' => 'AIDA model will help you ensure that any kind of writing, is as effective as possible', 'template_code' => 'WQJYP', 'status' => true, 'professional' => false, 'group' => 'framework', 'slug' => 'aida-frameword', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Name","placeholder":"Enter your product name here...", "required":1, "input":"input","code":"title", "length":200}, {"name":"Product Description","placeholder":"Enter more details here", "required":1, "input":"textarea","code":"description", "length":2000}]'],
            ['id' => 66, 'name' => 'Before–After–Bridge (BAB) Framework', 'icon' => '<i class="fa-solid fa-pen-nib framework-icon"></i>', 'description' => 'Conversion-oriented formula designed to make a particular offer more appealing', 'template_code' => 'APUSA', 'status' => true, 'professional' => false, 'group' => 'framework', 'slug' => 'bab-frameword', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Name","placeholder":"Enter your product name here...", "required":1, "input":"input","code":"title", "length":200}, {"name":"Product Description","placeholder":"Enter more details here", "required":1, "input":"textarea","code":"description", "length":2000}]'],
            ['id' => 67, 'name' => 'Promise–Picture–Proof–Push (PPPP) Framework', 'icon' => '<i class="fa-solid fa-pen-nib framework-icon"></i>', 'description' => 'Use 4P formula to craft persuasive content that moves readers to action', 'template_code' => 'AEJJV', 'status' => true, 'professional' => false, 'group' => 'framework', 'slug' => 'pppp-frameword', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Name","placeholder":"Enter your product name here...", "required":1, "input":"input","code":"title", "length":200}, {"name":"Product Description","placeholder":"Enter more details here", "required":1, "input":"textarea","code":"description", "length":2000}]'],
            ['id' => 68, 'name' => 'Brand Names', 'icon' => '<i class="fa-solid fa-copyright marketing-icon"></i>', 'description' => 'Generate unique brand names with the help of AI', 'template_code' => 'FYKJD', 'status' => true, 'professional' => false, 'group' => 'marketing', 'slug' => 'brand-names', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Description","placeholder":"Describe your product...", "required":1, "input":"textarea","code":"description", "length":800}]'],
            ['id' => 69, 'name' => 'Ad Headlines', 'icon' => '<i class="fa-sharp fa-solid fa-rectangle-ad ad-icon"></i>', 'description' => 'Write an attention grabbing ad headlines', 'template_code' => 'DYNJE', 'status' => true, 'professional' => false, 'group' => 'ad', 'slug' => 'ad-headlines', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Product Name","placeholder":"e.g. VR, Oculus", "required":1, "input":"input","code":"title", "length":200}, {"name":"Audience","placeholder":"e.g. Women, Aliens", "required":0, "input":"input","code":"audience", "length":200}, {"name":"Product Description","placeholder":"e.g. VR is an innovative device that can allow you to be part of virtual world", "required":1, "input":"textarea","code":"description", "length":600}]'],
            ['id' => 70, 'name' => 'Newsletter Generator', 'icon' => '<i class="fa-solid fa-newspaper web-icon"></i>', 'description' => 'Generate a newsletter based on the provided information', 'template_code' => 'SXFVD', 'status' => true, 'professional' => false, 'group' => 'web', 'slug' => 'newsletter-generator', 'type' => 'original', 'package' =>  'all', 'fields' => '[{"name":"Newsletter Description","placeholder":"Describe what it should be about...", "required":1, "input":"textarea","code":"description", "length":2000}]'],

        ];

        foreach ($templates as $template) {
            Template::updateOrCreate(['id' => $template['id']], $template);
        }
    }
}
